/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.google.common.collect.Maps;
import com.minecrafttas.tasmod.util.ContainerSerialiser;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualKeyboardEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.input.Keyboard;

public class VirtualKeyboard
implements Serializable {
    private static final long serialVersionUID = 4694772261313303998L;
    private Map<Integer, VirtualKey> keyList;
    private List<Character> charList;

    public VirtualKeyboard(Map<Integer, VirtualKey> keyListIn, List<Character> charListIn) {
        HashMap<Integer, VirtualKey> copy = new HashMap<Integer, VirtualKey>();
        keyListIn.forEach((key, value) -> copy.put((Integer)key, value.clone()));
        this.keyList = copy;
        ArrayList<Character> charCopy = new ArrayList<Character>();
        charListIn.forEach(charAction -> charCopy.add((Character)charAction));
        this.charList = charCopy;
    }

    public VirtualKeyboard() {
        this.charList = new ArrayList<Character>();
        this.keyList = Maps.newHashMap();
        this.keyList.put(0, new VirtualKey("0", 0));
        this.keyList.put(1, new VirtualKey("ESC", 1));
        this.keyList.put(2, new VirtualKey("KEY_1", 2));
        this.keyList.put(3, new VirtualKey("KEY_2", 3));
        this.keyList.put(4, new VirtualKey("KEY_3", 4));
        this.keyList.put(5, new VirtualKey("KEY_4", 5));
        this.keyList.put(6, new VirtualKey("KEY_5", 6));
        this.keyList.put(7, new VirtualKey("KEY_6", 7));
        this.keyList.put(8, new VirtualKey("KEY_7", 8));
        this.keyList.put(9, new VirtualKey("KEY_8", 9));
        this.keyList.put(10, new VirtualKey("KEY_9", 10));
        this.keyList.put(11, new VirtualKey("KEY_0", 11));
        this.keyList.put(12, new VirtualKey("MINUS", 12));
        this.keyList.put(13, new VirtualKey("EQUALS", 13));
        this.keyList.put(14, new VirtualKey("BACK", 14));
        this.keyList.put(15, new VirtualKey("TAB", 15));
        this.keyList.put(16, new VirtualKey("Q", 16));
        this.keyList.put(17, new VirtualKey("W", 17));
        this.keyList.put(18, new VirtualKey("E", 18));
        this.keyList.put(19, new VirtualKey("R", 19));
        this.keyList.put(20, new VirtualKey("T", 20));
        this.keyList.put(21, new VirtualKey("Y", 21));
        this.keyList.put(22, new VirtualKey("U", 22));
        this.keyList.put(23, new VirtualKey("I", 23));
        this.keyList.put(24, new VirtualKey("O", 24));
        this.keyList.put(25, new VirtualKey("P", 25));
        this.keyList.put(26, new VirtualKey("LBRACKET", 26));
        this.keyList.put(27, new VirtualKey("RBRACKET", 27));
        this.keyList.put(28, new VirtualKey("RETURN", 28));
        this.keyList.put(29, new VirtualKey("LCONTROL", 29));
        this.keyList.put(30, new VirtualKey("A", 30));
        this.keyList.put(31, new VirtualKey("S", 31));
        this.keyList.put(32, new VirtualKey("D", 32));
        this.keyList.put(33, new VirtualKey("F", 33));
        this.keyList.put(34, new VirtualKey("G", 34));
        this.keyList.put(35, new VirtualKey("H", 35));
        this.keyList.put(36, new VirtualKey("J", 36));
        this.keyList.put(37, new VirtualKey("K", 37));
        this.keyList.put(38, new VirtualKey("L", 38));
        this.keyList.put(39, new VirtualKey("SEMICOLON", 39));
        this.keyList.put(40, new VirtualKey("APOSTROPHE", 40));
        this.keyList.put(41, new VirtualKey("GRAVE", 41));
        this.keyList.put(42, new VirtualKey("LSHIFT", 42));
        this.keyList.put(43, new VirtualKey("BACKSLASH", 43));
        this.keyList.put(44, new VirtualKey("Z", 44));
        this.keyList.put(45, new VirtualKey("X", 45));
        this.keyList.put(46, new VirtualKey("C", 46));
        this.keyList.put(47, new VirtualKey("V", 47));
        this.keyList.put(48, new VirtualKey("B", 48));
        this.keyList.put(49, new VirtualKey("N", 49));
        this.keyList.put(50, new VirtualKey("M", 50));
        this.keyList.put(51, new VirtualKey("COMMA", 51));
        this.keyList.put(52, new VirtualKey("PERIOD", 52));
        this.keyList.put(53, new VirtualKey("SLASH", 53));
        this.keyList.put(54, new VirtualKey("RSHIFT", 54));
        this.keyList.put(55, new VirtualKey("MULTIPLY", 55));
        this.keyList.put(56, new VirtualKey("ALT", 56));
        this.keyList.put(57, new VirtualKey("SPACE", 57));
        this.keyList.put(58, new VirtualKey("CAPSLOCK", 58));
        this.keyList.put(59, new VirtualKey("F1", 59));
        this.keyList.put(60, new VirtualKey("F2", 60));
        this.keyList.put(61, new VirtualKey("F3", 61));
        this.keyList.put(62, new VirtualKey("F4", 62));
        this.keyList.put(63, new VirtualKey("F5", 63));
        this.keyList.put(64, new VirtualKey("F6", 64));
        this.keyList.put(65, new VirtualKey("F7", 65));
        this.keyList.put(66, new VirtualKey("F8", 66));
        this.keyList.put(67, new VirtualKey("F9", 67));
        this.keyList.put(68, new VirtualKey("F10", 68));
        this.keyList.put(69, new VirtualKey("NUMLOCK", 69));
        this.keyList.put(70, new VirtualKey("SCROLL", 70));
        this.keyList.put(71, new VirtualKey("NUMPAD7", 71));
        this.keyList.put(72, new VirtualKey("NUMPAD8", 72));
        this.keyList.put(73, new VirtualKey("NUMPAD9", 73));
        this.keyList.put(74, new VirtualKey("SUBTRACT", 74));
        this.keyList.put(75, new VirtualKey("NUMPAD4", 75));
        this.keyList.put(76, new VirtualKey("NUMPAD5", 76));
        this.keyList.put(77, new VirtualKey("NUMPAD6", 77));
        this.keyList.put(78, new VirtualKey("ADD", 78));
        this.keyList.put(79, new VirtualKey("NUMPAD1", 79));
        this.keyList.put(80, new VirtualKey("NUMPAD2", 80));
        this.keyList.put(81, new VirtualKey("NUMPAD3", 81));
        this.keyList.put(82, new VirtualKey("NUMPAD0", 82));
        this.keyList.put(83, new VirtualKey("DECIMAL", 83));
        this.keyList.put(87, new VirtualKey("F11", 87));
        this.keyList.put(88, new VirtualKey("F12", 88));
        this.keyList.put(100, new VirtualKey("F13", 100));
        this.keyList.put(101, new VirtualKey("F14", 101));
        this.keyList.put(102, new VirtualKey("F15", 102));
        this.keyList.put(103, new VirtualKey("F16", 103));
        this.keyList.put(104, new VirtualKey("F17", 104));
        this.keyList.put(105, new VirtualKey("F18", 105));
        this.keyList.put(112, new VirtualKey("KANA", 112));
        this.keyList.put(113, new VirtualKey("F19", 113));
        this.keyList.put(121, new VirtualKey("CONVERT", 121));
        this.keyList.put(123, new VirtualKey("NOCONVERT", 123));
        this.keyList.put(125, new VirtualKey("YEN", 125));
        this.keyList.put(141, new VirtualKey("NUMPADEQUALS", 141));
        this.keyList.put(144, new VirtualKey("CIRCUMFLEX", 144));
        this.keyList.put(145, new VirtualKey("AT", 145));
        this.keyList.put(146, new VirtualKey("COLON", 146));
        this.keyList.put(147, new VirtualKey("UNDERLINE", 147));
        this.keyList.put(148, new VirtualKey("KANJI", 148));
        this.keyList.put(149, new VirtualKey("STOP", 149));
        this.keyList.put(156, new VirtualKey("NUMPADENTER", 156));
        this.keyList.put(157, new VirtualKey("RCONTROL", 157));
        this.keyList.put(179, new VirtualKey("NUMPADCOMMA", 179));
        this.keyList.put(181, new VirtualKey("DIVIDE", 181));
        this.keyList.put(183, new VirtualKey("PRINT", 183));
        this.keyList.put(184, new VirtualKey("ALT_GR", 184));
        this.keyList.put(197, new VirtualKey("PAUSE", 197));
        this.keyList.put(199, new VirtualKey("HOME", 199));
        this.keyList.put(200, new VirtualKey("UP", 200));
        this.keyList.put(201, new VirtualKey("PRIOR", 201));
        this.keyList.put(203, new VirtualKey("LEFT", 203));
        this.keyList.put(205, new VirtualKey("RIGHT", 205));
        this.keyList.put(207, new VirtualKey("END", 207));
        this.keyList.put(208, new VirtualKey("DOWN", 208));
        this.keyList.put(209, new VirtualKey("NEXT", 209));
        this.keyList.put(210, new VirtualKey("INSERT", 210));
        this.keyList.put(211, new VirtualKey("DELETE", 211));
        this.keyList.put(219, new VirtualKey("WIN", 219));
        this.keyList.put(221, new VirtualKey("APPS", 221));
    }

    public void add(int keycode) {
        String keyString = Integer.toString(keycode);
        this.keyList.put(keycode, new VirtualKey(keyString, keycode));
    }

    public VirtualKey get(int keycode) {
        VirtualKey key = this.keyList.get(keycode);
        if (key == null) {
            this.add(keycode);
            return this.keyList.get(keycode);
        }
        return key;
    }

    public VirtualKey get(String keyname) {
        Collection<VirtualKey> list = this.keyList.values();
        VirtualKey out = null;
        for (VirtualKey key : list) {
            if (!key.getName().equalsIgnoreCase(keyname)) continue;
            out = key;
        }
        return out;
    }

    public List<String> getCurrentPresses() {
        ArrayList<String> out = new ArrayList<String>();
        this.keyList.forEach((keycodes, virtualkeys) -> {
            if (keycodes >= 0 && virtualkeys.isKeyDown()) {
                out.add(virtualkeys.getName());
            }
        });
        return out;
    }

    public Map<Integer, VirtualKey> getKeyList() {
        return this.keyList;
    }

    public void addChar(char charin) {
        this.charList.add(Character.valueOf(charin));
    }

    public List<Character> getCharList() {
        return this.charList;
    }

    public String getCharListAsString() {
        String out = "";
        for (char chars : this.charList) {
            out = out.concat(Character.toString(chars));
        }
        return out;
    }

    public void clearCharList() {
        this.charList.clear();
    }

    public void clear() {
        this.keyList.forEach((keycode, key) -> key.setPressed(false));
        this.charList.clear();
    }

    public List<VirtualKeyboardEvent> getDifference(VirtualKeyboard keyboardToCompare) {
        ArrayList<VirtualKeyboardEvent> eventList = new ArrayList<VirtualKeyboardEvent>();
        this.keyList.forEach((keycodes, virtualkeys) -> {
            VirtualKey keyToCompare = keyboardToCompare.get((int)keycodes);
            if (!virtualkeys.equals(keyToCompare)) {
                if (Keyboard.areRepeatEventsEnabled() && this.isUnicodeInList((int)keycodes)) {
                    return;
                }
                eventList.add(new VirtualKeyboardEvent((int)keycodes, keyToCompare.isKeyDown(), '\u0000'));
            }
        });
        keyboardToCompare.charList.forEach(action -> {
            if (Keyboard.areRepeatEventsEnabled()) {
                eventList.add(this.decodeUnicode(action.charValue()));
            } else {
                eventList.add(new VirtualKeyboardEvent(0, true, action.charValue()));
            }
        });
        return eventList;
    }

    public char encodeUnicode(int keycode, char character) {
        switch (keycode) {
            case 15: {
                return '\u21a6';
            }
            case 199: {
                return '\u21e4';
            }
            case 200: {
                return '\u2191';
            }
            case 201: {
                return '\u21e7';
            }
            case 203: {
                return '\u2190';
            }
            case 205: {
                return '\u2192';
            }
            case 207: {
                return '\u21e5';
            }
            case 208: {
                return '\u2193';
            }
            case 209: {
                return '\u21e9';
            }
        }
        return character;
    }

    public VirtualKeyboardEvent decodeUnicode(char character) {
        switch (character) {
            case '\b': {
                return new VirtualKeyboardEvent(14, true, character);
            }
            case '\u21a6': {
                return new VirtualKeyboardEvent(15, true, '\u0000');
            }
            case '\u2907': {
                return new VirtualKeyboardEvent(15, false, '\u0000');
            }
            case '\u21e4': {
                return new VirtualKeyboardEvent(199, true, '\u0000');
            }
            case '\u2191': {
                return new VirtualKeyboardEvent(200, true, '\u0000');
            }
            case '\u21e7': {
                return new VirtualKeyboardEvent(201, true, '\u0000');
            }
            case '\u2190': {
                return new VirtualKeyboardEvent(203, true, '\u0000');
            }
            case '\u2192': {
                return new VirtualKeyboardEvent(205, true, '\u0000');
            }
            case '\u21e5': {
                return new VirtualKeyboardEvent(207, true, '\u0000');
            }
            case '\u2193': {
                return new VirtualKeyboardEvent(208, true, '\u0000');
            }
            case '\u21e9': {
                return new VirtualKeyboardEvent(209, true, '\u0000');
            }
        }
        return new VirtualKeyboardEvent(0, true, character);
    }

    public boolean isUnicodeInList(int keycode) {
        switch (keycode) {
            case 14: 
            case 15: 
            case 199: 
            case 200: 
            case 201: 
            case 203: 
            case 205: 
            case 207: 
            case 208: 
            case 209: {
                return true;
            }
        }
        return false;
    }

    public VirtualKeyboard clone() {
        return new VirtualKeyboard(this.keyList, this.charList);
    }

    public String toString() {
        int i;
        List<String> stringy = this.getCurrentPresses();
        String keyString = "";
        if (!stringy.isEmpty()) {
            String seperator = ",";
            for (i = 0; i < stringy.size(); ++i) {
                if (i == stringy.size() - 1) {
                    seperator = "";
                }
                keyString = keyString.concat(stringy.get(i) + seperator);
            }
        }
        String charString = "";
        if (!this.charList.isEmpty()) {
            for (i = 0; i < this.charList.size(); ++i) {
                charString = charString.concat(Character.toString(this.charList.get(i).charValue()));
            }
            charString = StringUtils.replace((String)charString, (String)"\r", (String)"\\n");
            charString = StringUtils.replace((String)charString, (String)"\n", (String)"\\n");
        }
        return ContainerSerialiser.SectionsV1.KEYBOARD.getName() + ":" + keyString + ";" + charString;
    }
}

