/*
 * Decompiled with CFR 0.152.
 */
package com.minecrafttas.tasmod.virtual;

import com.google.common.collect.Maps;
import com.minecrafttas.tasmod.util.ContainerSerialiser;
import com.minecrafttas.tasmod.virtual.VirtualKey;
import com.minecrafttas.tasmod.virtual.VirtualMouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VirtualMouse
implements Serializable {
    private static final long serialVersionUID = -5389661329436686190L;
    private Map<Integer, VirtualKey> keyList = Maps.newHashMap();
    private int scrollwheel = 0;
    private int cursorX = 0;
    private int cursorY = 0;
    List<PathNode> path = new ArrayList<PathNode>();

    public VirtualMouse(Map<Integer, VirtualKey> keyListIn, int scrollwheel, int cursorX, int cursorY, List<PathNode> path) {
        HashMap<Integer, VirtualKey> copy = new HashMap<Integer, VirtualKey>();
        keyListIn.forEach((key, value) -> copy.put((Integer)key, value.clone()));
        this.keyList = copy;
        this.scrollwheel = scrollwheel;
        this.cursorX = cursorX;
        this.cursorY = cursorY;
        ArrayList<PathNode> pathCopy = new ArrayList<PathNode>();
        path.forEach(pathNode -> pathCopy.add((PathNode)pathNode));
        this.path = pathCopy;
    }

    public VirtualMouse() {
        this.keyList.put(-101, new VirtualKey("MOUSEMOVED", -101));
        this.keyList.put(-100, new VirtualKey("LC", -100));
        this.keyList.put(-99, new VirtualKey("RC", -99));
        this.keyList.put(-98, new VirtualKey("MC", -98));
        this.keyList.put(-97, new VirtualKey("MBUTTON4", -97));
        this.keyList.put(-96, new VirtualKey("MBUTTON5", -96));
        this.keyList.put(-95, new VirtualKey("MBUTTON6", -95));
        this.keyList.put(-94, new VirtualKey("MBUTTON7", -94));
        this.keyList.put(-93, new VirtualKey("MBUTTON8", -93));
        this.keyList.put(-92, new VirtualKey("MBUTTON9", -92));
        this.keyList.put(-91, new VirtualKey("MBUTTON10", -91));
        this.keyList.put(-90, new VirtualKey("MBUTTON11", -90));
        this.keyList.put(-89, new VirtualKey("MBUTTON12", -89));
        this.keyList.put(-88, new VirtualKey("MBUTTON13", -88));
        this.keyList.put(-87, new VirtualKey("MBUTTON14", -87));
        this.keyList.put(-86, new VirtualKey("MBUTTON15", -86));
        this.keyList.put(-85, new VirtualKey("MBUTTON16", -85));
        this.scrollwheel = 0;
        this.cursorX = 0;
        this.cursorY = 0;
        this.addPathNode();
    }

    public void add(int keycode) {
        String keyString = Integer.toString(keycode);
        this.keyList.put(keycode, new VirtualKey(keyString, keycode));
    }

    public VirtualKey get(int keycode) {
        return this.keyList.get(keycode);
    }

    public VirtualKey get(String keyname) {
        Collection<VirtualKey> list = this.keyList.values();
        VirtualKey out = null;
        for (VirtualKey key : list) {
            if (!key.getName().equalsIgnoreCase(keyname)) continue;
            out = key;
        }
        return out;
    }

    public List<String> getCurrentPresses() {
        ArrayList<String> out = new ArrayList<String>();
        this.keyList.forEach((keycodes, virtualkeys) -> {
            if (keycodes <= 0 && virtualkeys.isKeyDown()) {
                out.add(virtualkeys.getName());
            }
        });
        return out;
    }

    public Map<Integer, VirtualKey> getKeyList() {
        return this.keyList;
    }

    public List<VirtualMouseEvent> getDifference(VirtualMouse mouseToCompare) {
        ArrayList<VirtualMouseEvent> eventList = new ArrayList<VirtualMouseEvent>();
        List<PathNode> path = mouseToCompare.getPath();
        if (path.size() != 1) {
            for (int i = 0; i < path.size() - 1; ++i) {
                PathNode currentNode = path.get(i);
                PathNode nextNode = path.get(i + 1);
                boolean flag = false;
                for (VirtualKey key : nextNode.keyList.values()) {
                    if (key.equals(currentNode.keyList.get(key.getKeycode()))) continue;
                    eventList.add(new VirtualMouseEvent(key.getKeycode(), key.isKeyDown(), nextNode.scrollwheel, nextNode.cursorX, nextNode.cursorY));
                    flag = true;
                    break;
                }
                if (flag) continue;
                eventList.add(new VirtualMouseEvent(-101, false, nextNode.scrollwheel, nextNode.cursorX, nextNode.cursorY));
            }
        } else {
            this.keyList.forEach((keycodes, virtualkeys) -> {
                VirtualKey keyToCompare = mouseToCompare.get((int)keycodes);
                if (!virtualkeys.equals(keyToCompare)) {
                    eventList.add(new VirtualMouseEvent((int)keycodes, keyToCompare.isKeyDown(), this.scrollwheel, this.cursorX, this.cursorY));
                }
            });
        }
        return eventList;
    }

    public boolean isSomethingDown() {
        for (VirtualKey key : this.keyList.values()) {
            if (!key.isKeyDown()) continue;
            return true;
        }
        return false;
    }

    public boolean isSomethingDown(Map<Integer, VirtualKey> keyList) {
        for (VirtualKey key : keyList.values()) {
            if (!key.isKeyDown()) continue;
            return true;
        }
        return false;
    }

    public VirtualMouse clone() {
        return new VirtualMouse(this.keyList, this.scrollwheel, this.cursorX, this.cursorY, this.path);
    }

    public void setCursor(int x, int y) {
        this.cursorX = x;
        this.cursorY = y;
    }

    public void setScrollWheel(int scrollwheel) {
        this.scrollwheel = scrollwheel;
    }

    public List<PathNode> getPath() {
        return this.path;
    }

    public String getPathAsString() {
        String out = "";
        for (PathNode node : this.path) {
            out = out.concat(node.toString());
        }
        return out;
    }

    public void addPathNode() {
        this.path.add(new PathNode(this.keyList, this.scrollwheel, this.cursorX, this.cursorY));
    }

    public void resetPath() {
        this.path.clear();
        this.addPathNode();
    }

    public void clear() {
        this.keyList.forEach((keycode, key) -> key.setPressed(false));
        this.resetPath();
    }

    public String toString() {
        List<String> stringy = this.getCurrentPresses();
        String keyString = "";
        if (!stringy.isEmpty()) {
            String seperator = ",";
            for (int i = 0; i < stringy.size(); ++i) {
                if (i == stringy.size() - 1) {
                    seperator = "";
                }
                keyString = keyString.concat(stringy.get(i) + seperator);
            }
        }
        String pathString = "";
        if (!this.path.isEmpty()) {
            String seperator = "->";
            for (int i = 0; i < this.path.size(); ++i) {
                if (i == this.path.size() - 1) {
                    seperator = "";
                }
                pathString = pathString.concat("[" + this.path.get(i).toString() + "]" + seperator);
            }
        }
        return ContainerSerialiser.SectionsV1.MOUSE.getName() + ":" + keyString + ";" + pathString;
    }

    public void setPath(List<PathNode> path) {
        ArrayList<PathNode> pathCopy = new ArrayList<PathNode>();
        path.forEach(pathNode -> pathCopy.add((PathNode)pathNode));
        this.path = pathCopy;
    }

    public class PathNode
    implements Serializable {
        private static final long serialVersionUID = -2221602955260299028L;
        private Map<Integer, VirtualKey> keyList = Maps.newHashMap();
        public int scrollwheel = 0;
        public int cursorX = 0;
        public int cursorY = 0;

        public PathNode(Map<Integer, VirtualKey> keyList, int scrollwheel, int cursorX, int cursorY) {
            HashMap<Integer, VirtualKey> copy = new HashMap<Integer, VirtualKey>();
            keyList.forEach((key, value) -> copy.put((Integer)key, value.clone()));
            this.keyList = copy;
            this.scrollwheel = scrollwheel;
            this.cursorX = cursorX;
            this.cursorY = cursorY;
        }

        public PathNode() {
            this.keyList.put(-101, new VirtualKey("MOUSEMOVED", -101));
            this.keyList.put(-100, new VirtualKey("LC", -100));
            this.keyList.put(-99, new VirtualKey("RC", -99));
            this.keyList.put(-98, new VirtualKey("MC", -98));
            this.keyList.put(-97, new VirtualKey("MBUTTON3", -97));
            this.keyList.put(-96, new VirtualKey("MBUTTON4", -96));
            this.keyList.put(-95, new VirtualKey("MBUTTON5", -95));
            this.keyList.put(-94, new VirtualKey("MBUTTON6", -94));
            this.keyList.put(-93, new VirtualKey("MBUTTON7", -93));
            this.keyList.put(-92, new VirtualKey("MBUTTON8", -92));
            this.keyList.put(-91, new VirtualKey("MBUTTON9", -91));
            this.keyList.put(-90, new VirtualKey("MBUTTON10", -90));
            this.keyList.put(-89, new VirtualKey("MBUTTON11", -89));
            this.keyList.put(-88, new VirtualKey("MBUTTON12", -88));
            this.keyList.put(-87, new VirtualKey("MBUTTON13", -87));
            this.keyList.put(-86, new VirtualKey("MBUTTON14", -86));
            this.keyList.put(-85, new VirtualKey("MBUTTON15", -85));
            this.scrollwheel = 0;
            this.cursorX = 0;
            this.cursorY = 0;
        }

        public String toString() {
            String keyString = "";
            ArrayList strings = new ArrayList();
            this.keyList.forEach((keycodes, virtualkeys) -> {
                if (virtualkeys.isKeyDown()) {
                    strings.add(virtualkeys.getName());
                }
            });
            if (!strings.isEmpty()) {
                String seperator = ",";
                for (int i = 0; i < strings.size(); ++i) {
                    if (i == strings.size() - 1) {
                        seperator = "";
                    }
                    keyString = keyString.concat((String)strings.get(i) + seperator);
                }
            }
            if (keyString.isEmpty()) {
                return "MOUSEMOVED," + this.scrollwheel + "," + this.cursorX + "," + this.cursorY;
            }
            return keyString + "," + this.scrollwheel + "," + this.cursorX + "," + this.cursorY;
        }

        public VirtualKey get(String keyname) {
            Collection<VirtualKey> list = this.keyList.values();
            VirtualKey out = null;
            for (VirtualKey key : list) {
                if (!key.getName().equalsIgnoreCase(keyname)) continue;
                out = key;
            }
            return out;
        }
    }
}

