/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization.coders;

import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonFactory;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonGenerator;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.JsonStreamContext;
import com.minecrafttas.tasmod.repack.com.fasterxml.jackson.core.io.SerializedString;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.Map;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTEncoder;
import org.nustaq.serialization.FSTObjectOutput;
import org.nustaq.serialization.coders.JSONAsString;
import org.nustaq.serialization.coders.Unknown;
import org.nustaq.serialization.util.FSTOutputStream;
import org.nustaq.serialization.util.FSTUtil;

public class FSTJsonEncoder
implements FSTEncoder {
    public static final String TYPE = "typ";
    public static final String OBJ = "obj";
    public static final String SEQ_TYPE = "styp";
    public static final String SEQ = "seq";
    public static final String ENUM = "enum";
    public static final String VAL = "val";
    public static final String REF = "ref";
    public static final SerializedString TYPE_S = new SerializedString("typ");
    public static final SerializedString OBJ_S = new SerializedString("obj");
    public static final SerializedString SEQ_TYPE_S = new SerializedString("styp");
    public static final SerializedString SEQ_S = new SerializedString("seq");
    public static final SerializedString ENUM_S = new SerializedString("enum");
    public static final SerializedString VAL_S = new SerializedString("val");
    public static final SerializedString REF_S = new SerializedString("ref");
    JsonFactory fac;
    FSTConfiguration conf;
    protected JsonGenerator gen;
    FSTOutputStream out;

    public FSTJsonEncoder(FSTConfiguration conf) {
        this.conf = conf;
        this.fac = (JsonFactory)conf.getCoderSpecific();
    }

    @Override
    public void setConf(FSTConfiguration conf) {
        this.conf = conf;
    }

    @Override
    public void writeRawBytes(byte[] bufferedName, int off, int length) throws IOException {
        this.gen.writeBinary(bufferedName, off, length);
    }

    @Override
    public void writePrimitiveArray(Object array, int start, int length) throws IOException {
        this.gen.writeStartArray();
        Class<?> componentType = array.getClass().getComponentType();
        if (componentType == Integer.TYPE) {
            int[] arr = (int[])array;
            for (int i = 0; i < length; ++i) {
                this.gen.writeNumber(arr[i]);
            }
            this.gen.writeEndArray();
            return;
        }
        this.gen.writeString(componentType.getSimpleName());
        if (array instanceof boolean[]) {
            boolean[] arr = (boolean[])array;
            for (int i = 0; i < length; ++i) {
                this.gen.writeBoolean(arr[i]);
            }
        } else if (array instanceof long[]) {
            long[] arr = (long[])array;
            for (int i = 0; i < length; ++i) {
                this.gen.writeNumber(arr[i]);
            }
        } else if (array instanceof double[]) {
            double[] arr = (double[])array;
            for (int i = 0; i < length; ++i) {
                this.gen.writeNumber(arr[i]);
            }
        } else if (array instanceof char[]) {
            char[] arr = (char[])array;
            for (int i = 0; i < length; ++i) {
                this.gen.writeNumber(arr[i]);
            }
        } else {
            for (int i = 0; i < length; ++i) {
                Number num = (Number)Array.get(array, start + i);
                if (num instanceof Float || num instanceof Double) {
                    this.gen.writeNumber(num.doubleValue());
                    continue;
                }
                this.gen.writeNumber(num.longValue());
            }
        }
        this.gen.writeEndArray();
    }

    @Override
    public void writeStringUTF(String str) throws IOException {
        this.gen.writeString(str);
    }

    @Override
    public void writeFShort(short c) throws IOException {
        this.gen.writeNumber(c);
    }

    @Override
    public void writeFChar(char c) throws IOException {
        this.gen.writeNumber(c);
    }

    @Override
    public void writeFByte(int v) throws IOException {
        this.gen.writeNumber(v);
    }

    @Override
    public void writeFInt(int anInt) throws IOException {
        this.gen.writeNumber(anInt);
    }

    @Override
    public void writeFLong(long anInt) throws IOException {
        this.gen.writeNumber(anInt);
    }

    @Override
    public void writeFFloat(float value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public void writeFDouble(double value) throws IOException {
        this.gen.writeNumber(value);
    }

    @Override
    public int getWritten() {
        return this.out.pos - this.out.getOff() + ((FSTConfiguration.JacksonAccessWorkaround)this.gen).getOutputTail();
    }

    @Override
    public void skip(int i) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void close() throws IOException {
        this.gen.close();
        this.out.close();
    }

    @Override
    public void reset(byte[] outbytes) {
        if (outbytes == null) {
            this.out.reset();
        } else {
            this.out.reset(outbytes);
        }
    }

    @Override
    public void flush() throws IOException {
        this.gen.flush();
        this.out.flush();
    }

    @Override
    public void writeInt32At(int position, int v) {
        throw new RuntimeException("not supported");
    }

    @Override
    public void setOutstream(OutputStream outstream) {
        this.out = new FSTOutputStream(outstream);
        try {
            this.createGenerator();
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    public void createGenerator() throws IOException {
        if (this.gen != null) {
            this.gen.close();
        }
        this.gen = this.fac.createGenerator(this.out);
    }

    @Override
    public void ensureFree(int bytes) throws IOException {
        this.out.ensureFree(bytes);
    }

    @Override
    public byte[] getBuffer() {
        try {
            this.gen.flush();
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
        return this.out.getBuf();
    }

    @Override
    public void registerClass(Class possible) {
    }

    @Override
    public void writeClass(Class cl) {
    }

    @Override
    public void writeClass(FSTClazzInfo clInf) {
    }

    @Override
    public boolean writeTag(byte tag, Object infoOrObject, long somValue, Object toWrite, FSTObjectOutput oout) throws IOException {
        switch (tag) {
            case -7: {
                this.gen.writeStartObject();
                this.gen.writeFieldName(REF_S);
                this.gen.writeNumber(somValue);
                this.gen.writeEndObject();
                return true;
            }
            case -1: {
                this.gen.writeNull();
                return true;
            }
            case -3: 
            case 0: {
                if (toWrite instanceof Unknown) {
                    this.writeUnkown((Unknown)toWrite, oout);
                    return true;
                }
                FSTClazzInfo clzInfo = (FSTClazzInfo)infoOrObject;
                if (clzInfo.useCompatibleMode() && clzInfo.getSer() == null) {
                    throw new RuntimeException("Unsupported backward compatibility mode for class '" + clzInfo.getClazz().getName() + "'. Pls register a Custom Serializer to fix");
                }
                if (clzInfo.getClazz() == String.class || clzInfo.getClazz() == Double.class || clzInfo.getClazz() == Float.class || clzInfo.getClazz() == Byte.class || clzInfo.getClazz() == Short.class || clzInfo.getClazz() == Integer.class || clzInfo.getClazz() == Long.class || clzInfo.getClazz() == Character.class || clzInfo.getClazz() == Boolean.class) break;
                if (clzInfo.getSer() != null || clzInfo.isExternalizable()) {
                    this.gen.writeStartObject();
                    this.gen.writeFieldName(TYPE_S);
                    this.writeSymbolicClazz(clzInfo, clzInfo.getClazz());
                    this.gen.writeFieldName(OBJ_S);
                    this.gen.writeStartArray();
                    break;
                }
                this.gen.writeStartObject();
                this.gen.writeFieldName(TYPE_S);
                this.writeSymbolicClazz(clzInfo, clzInfo.getClazz());
                this.gen.writeFieldName(OBJ_S);
                this.gen.writeStartObject();
                break;
            }
            case -18: {
                throw new RuntimeException("not implemented");
            }
            case -4: {
                break;
            }
            case -17: {
                this.gen.writeBoolean(Boolean.FALSE);
                break;
            }
            case -16: {
                this.gen.writeBoolean(Boolean.TRUE);
                break;
            }
            case -10: {
                break;
            }
            case -9: {
                break;
            }
            case -5: {
                Class<?> clz = infoOrObject.getClass();
                Class<?> componentType = clz.getComponentType();
                if (clz.isArray() && componentType.isPrimitive()) {
                    this.writePrimitiveArray(infoOrObject, 0, Array.getLength(infoOrObject));
                    return true;
                }
                this.gen.writeStartObject();
                this.gen.writeFieldName(SEQ_TYPE_S);
                this.writeSymbolicClazz(null, clz);
                this.gen.writeFieldName(SEQ_S);
                this.gen.writeStartArray();
                break;
            }
            case -6: {
                boolean isEnumClass = toWrite.getClass().isEnum();
                Class<?> c = toWrite.getClass();
                if (!isEnumClass) {
                    while (c != null && !c.isEnum()) {
                        c = toWrite.getClass().getSuperclass();
                    }
                    if (c == null) {
                        throw new RuntimeException("Can't handle this enum: " + toWrite.getClass());
                    }
                }
                this.gen.writeStartObject();
                this.gen.writeFieldName(ENUM_S);
                this.writeSymbolicClazz(null, c);
                this.gen.writeFieldName(VAL_S);
                this.gen.writeString(toWrite.toString());
                this.gen.writeEndObject();
                return true;
            }
            default: {
                throw new RuntimeException("unexpected tag " + tag);
            }
        }
        return false;
    }

    private void writeUnkown(Unknown toWrite, FSTObjectOutput oout) throws IOException {
        this.gen.writeStartObject();
        this.gen.writeFieldName(TYPE_S);
        this.gen.writeString(toWrite.getType());
        this.gen.writeFieldName(OBJ_S);
        if (toWrite.isSequence()) {
            this.gen.writeStartArray();
            for (Object o : toWrite.getItems()) {
                oout.writeObject(o);
            }
            this.gen.writeEndArray();
        } else {
            this.gen.writeStartObject();
            for (Map.Entry<String, Object> stringObjectEntry : toWrite.getFields().entrySet()) {
                this.gen.writeFieldName(stringObjectEntry.getKey());
                oout.writeObject(stringObjectEntry.getValue());
            }
            this.gen.writeEndObject();
        }
        this.gen.writeEndObject();
    }

    private void writeSymbolicClazz(FSTClazzInfo clzInfo, Class<?> clz) {
        try {
            if (clzInfo != null) {
                SerializedString buffered = (SerializedString)clzInfo.getDecoderAttached();
                if (buffered == null) {
                    buffered = new SerializedString(this.classToString(clz));
                    clzInfo.setDecoderAttached(buffered);
                }
                this.gen.writeString(buffered);
            } else {
                this.gen.writeString(this.classToString(clz));
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    protected String classToString(Class clz) {
        return this.conf.getCPNameForClass(clz);
    }

    @Override
    public boolean writeAttributeName(FSTClazzInfo.FSTFieldInfo subInfo, Object outerObjectToWrite) {
        block8: {
            try {
                SerializedString bufferedName = (SerializedString)subInfo.getBufferedName();
                if (bufferedName == null) {
                    bufferedName = new SerializedString(subInfo.getName());
                    subInfo.setBufferedName(bufferedName);
                }
                if (this.gen.getOutputContext().inArray()) {
                    this.gen.writeString(bufferedName);
                } else {
                    this.gen.writeFieldName(bufferedName);
                }
                if (!subInfo.getField().isAnnotationPresent(JSONAsString.class)) break block8;
                try {
                    Object objectValue = subInfo.getObjectValue(outerObjectToWrite);
                    if (objectValue instanceof byte[]) {
                        String stringVal = new String((byte[])objectValue, "UTF-8");
                        this.writeStringUTF(stringVal);
                        return true;
                    }
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            catch (IOException e) {
                FSTUtil.rethrow(e);
            }
        }
        return false;
    }

    @Override
    public void externalEnd(FSTClazzInfo clz) {
        try {
            Class clazz = clz.getClazz();
            if (clazz == Byte.class || clazz == Short.class || clazz == Integer.class || clazz == Long.class || clazz == Float.class || clazz == Double.class || clazz == Character.class || clazz == Boolean.class) {
                return;
            }
            if (this.gen.getOutputContext().inArray()) {
                this.gen.writeEndArray();
            }
            if (this.gen.getOutputContext().inObject()) {
                this.gen.writeEndObject();
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public boolean isWritingAttributes() {
        return true;
    }

    @Override
    public boolean isPrimitiveArray(Object array, Class<?> componentType) {
        return componentType.isPrimitive() && !(array instanceof double[]) && !(array instanceof float[]);
    }

    @Override
    public boolean isTagMultiDimSubArrays() {
        return true;
    }

    @Override
    public void writeVersionTag(int version) throws IOException {
    }

    @Override
    public boolean isByteArrayBased() {
        return true;
    }

    @Override
    public void writeArrayEnd() {
        try {
            if (this.gen.getOutputContext().inArray()) {
                this.gen.writeEndArray();
            }
            if (this.gen.getOutputContext().inObject()) {
                this.gen.writeEndObject();
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
        }
    }

    @Override
    public void writeFieldsEnd(FSTClazzInfo serializationInfo) {
        try {
            JsonStreamContext outputContext = this.gen.getOutputContext();
            if (outputContext.inObject()) {
                this.gen.writeEndObject();
            } else {
                this.gen.writeEndArray();
            }
            if (outputContext.inObject()) {
                this.gen.writeEndObject();
            }
        }
        catch (IOException e) {
            FSTUtil.rethrow(e);
            try {
                this.gen.flush();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            System.out.println(new String(this.out.buf, 0, this.out.pos));
        }
    }

    @Override
    public FSTConfiguration getConf() {
        return this.conf;
    }
}

